using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_MonitorDataOzoneChina : UserControl
    {
        private int _wVNAPanelHeight;
        public uc_MonitorDataOzoneChina()
        {
            InitializeComponent();

            _wVNAPanelHeight = pnlwVNA.Height;
            txtwVNAWeight.Text = "0.5";

            Toggle();
            return;
        }
        string path = "";

        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20191119
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina = new MonitorDataOzoneChina();
                choIAdjustedFRMChina.Checked = false;
                choIFRMChina.Checked = false;
                chkwVNA.Checked = false;
                chkwVNAAdvance.Checked = false;
                chkNS.Checked = false;           
                cboEndYearOzone.Items.Clear();
                cboStartYearOzone.Items.Clear();
                if (CommonClass.dicExampleConfiguration != null)
                {
                    CommonClass.ozoneMonitorFile = CommonClass.dicExampleConfiguration["Ozone"]["ozoneMonitorDataFile"];// Application.StartupPath + @"\Data\SampleData\SMAT-China\Ozone_Data_Seasonal_2013_YRD.csv";
                    txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);

                    CommonClass.getmonitorYear("");
                    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear);
                    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear);

                    foreach (var item in (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.lstOzoneMonitorData)
                    {
                        cboEndYearOzone.Items.Add(item);
                        cboStartYearOzone.Items.Add(item);
                    }
                    cboStartYearOzone.SelectedIndex = 0;
                    cboEndYearOzone.SelectedIndex = end - start;
                }
            }
            else
            {
                choIFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useVNA;
                choIAdjustedFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useEVNA;
                chkwVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNA;
                chkwVNAAdvance.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAAdvancedOption;
                chkNS.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useNS;
                txtwVNAWeight.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAWeight.ToString();
                CommonClass.ozoneMonitorFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile;
                txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear;
                cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear;

                int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear);
                int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear);
                for (int i = start; i <= end; i++)
                {
                    cboEndYearOzone.Items.Add(i);
                    cboStartYearOzone.Items.Add(i);
                }
                cboStartYearOzone.SelectedIndex = 0;
                cboEndYearOzone.SelectedIndex = end - start;
            }
        }

        private void btnOzoneData_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog open = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.ozoneMonitorFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.ozoneMonitorFile)))
                    {
                        open.InitialDirectory = Application.StartupPath + @"\Data\SampleData\";
                    }
                    else
                    {
                        open.InitialDirectory = Path.GetDirectoryName(CommonClass.ozoneMonitorFile);
                    }
                }
                else
                    open.InitialDirectory = path;
                open.Title = LanguageOld.Translate("Select file...");
                open.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (open.ShowDialog() == DialogResult.OK)
                {
                    //default file = open.FileName;                    
                    CommonClass.ozoneMonitorFile = open.FileName;
                    txtOzoneData.Text = Path.GetFileName(open.FileName);
                    path = Path.GetDirectoryName(open.FileName);
                    open.RestoreDirectory = true;

                    //------add Years to cbox------
                    cboEndYearOzone.Items.Clear();
                    cboStartYearOzone.Items.Clear();
                    bool GetYears = CommonClass.getmonitorYear("");
                    if (!GetYears)
                    {
                        MessageBox.Show("Monitor Data is ill-formatted data!");
                    }
                    else
                    {
                        int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear);
                        int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear);
                        //for (int i = start; i <= end; i++)
                        //{
                        //    cboEndYearOzone.Items.Add(i);
                        //    cboStartYearOzone.Items.Add(i);
                        //}
                        foreach (var item in (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.lstOzoneMonitorData)
                        {
                            cboStartYearOzone.Items.Add(item);
                            cboEndYearOzone.Items.Add(item);
                        }
                        cboStartYearOzone.SelectedIndex = 0;
                        cboEndYearOzone.SelectedIndex = end - start;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void Toggle()
        {
            Toggle_wVNA();
        }

        private void Toggle_wVNA()
        {
            if (chkwVNA.Checked)
            {
                pnlwVNA.Visible = true;
                choIFRMChina.Checked = true;
                choIAdjustedFRMChina.Checked = true;
                if (chkwVNAAdvance.Checked)
                {
                    pnlwVNAAdvanced.Visible = true;
                    pnlwVNA.Height = _wVNAPanelHeight;
                }
                else
                {
                    pnlwVNAAdvanced.Visible = false;
                    pnlwVNA.Height = _wVNAPanelHeight - pnlwVNAAdvanced.Height;
                }
            }
            else
            {
                pnlwVNA.Visible = false;
                pnlwVNA.Height = 0;
            }

            chkNS.Location = new Point(chkNS.Location.X, pnlwVNA.Location.Y + pnlwVNA.Height);
        }

        private void chkwVNA_Click(object sender, EventArgs e)
        {
            Toggle();
            return;

            // wVNA��VNA��eVNA���ۺ�
            if (chkwVNA.Checked)
            {
                choIFRMChina.Checked = true;
                choIAdjustedFRMChina.Checked = true;
            }
            pnlwVNA.Visible = chkwVNA.Checked;
            pnlwVNAAdvanced.Visible = chkwVNAAdvance.Checked;
        }

        private void chkwVNAAdvance_Click(object sender, EventArgs e)
        {
            Toggle();
            return;
            pnlwVNAAdvanced.Visible = chkwVNAAdvance.Checked;
        }

        private void txtwVNAWeight_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == 0x20) e.KeyChar = (char)0;  //��ֹ�ո��

            //if (e.KeyChar == (char)46) e.KeyChar = (char)0;

            if ((e.KeyChar == 0x2D) && (((TextBox)sender).Text.Length == 0)) return;   //�������

            if (e.KeyChar > 0x20)
            {
                double result = 0;
                if (!double.TryParse(((TextBox)sender).Text + e.KeyChar.ToString(), out result))
                {
                    e.KeyChar = (char)0;
                }
            }
        }
    }
}
